diff --git a/init/do_mounts.c b/init/do_mounts.c
index dc1ec08..8aa013d 100644
--- a/init/do_mounts.c
+++ b/init/do_mounts.c
@@ -14,6 +14,7 @@
 #include <linux/nfs_fs_sb.h>
 #include <linux/nfs_mount.h>
 
+#include <linux/delay.h>
 #include "do_mounts.h"
 
 extern int get_filesystem_list(char * buf);
@@ -268,7 +269,12 @@ static void __init get_fs_names(char *page)
 
 static int __init do_mount_root(char *name, char *fs, int flags, void *data)
 {
-	int err = sys_mount(name, "/root", fs, flags, data);
+	int i=20, err=-1;
+	while (i-- && (err = sys_mount(name, "/root", fs, flags, data))!=0)
+	{
+		set_current_state(TASK_INTERRUPTIBLE);
+		schedule_timeout(HZ);
+	}
 	if (err)
 		return err;
 
