#set terminal png
set terminal png x111111 xffffff
#set output "chrge.svg"
#set size 1.0,.5
set format x "%y%m%d\n%H:%M"
#set format x "%H:%M"
#set timefmt "%Y-%m-%d %H:%M:%S"
set timefmt "%y%m%d %H:%M"
set yrange [ -5 : 25 ] noreverse nowriteback
set ytics 1
#set ticscale 5 1
#set time 
set  xdata time
# time range must be in same format as data file
#set xrange ["2008-11-17 08:00":"2008-11-17 22:18"]
#set xrange ["2010-08-26 20:00":"2010-08-28 14:00"]
#set xrange ["0-13:00:00":"0-14:00:00"]


set style line 1 lt 1 lw 1 pt 3 linecolor rgb "red"
set style line 2 lt 1 lw 1 pt 3 linecolor rgb "blue"
set style line 3 lt 1 lw 1 pt 3 linecolor rgb "green"
set style line 4 lt 1 lw 1 pt 3 linecolor rgb "yellow"
set style line 5 lt 1 lw 1 pt 3 linecolor rgb "brown"
set style line 6 lt 1 lw 1 pt 3 linecolor rgb "white"

set title "Power-Controller for herjulf.se\nCharging 12V/55Ah Lead-Acid battery with AC-adapter"

set ylabel "Voltage/Current/Temp"

float = 13.39
charge = 14.5


plot    "q2.dat" using 1:($3) title "Battery voltage" with line ls 1, \
        "q2.dat" using 1:($6) title "Input current" with line ls 2, \
        "q2.dat" using 1:($8) title "Disconnect voltage limit" with line ls 3, \
        "q2.dat" using 1:($14) title "Battery current" with line ls 4, \
        "q2.dat" using 1:($13*($6-$14)) title "Load power usage" with line ls 5, \
        float title  "Floating voltage" with line ls 6; \
#charge title "Charge-thresh" with line 3 0




#pause -1;
