#!/bin/bash
# 120312 --ro

# ARG-1 ID 
# ARG-2 to tail 
# ARG-3 Filname

PTH=/usr/local/scripts
WEB=/www/www.herjulf.net/projects/sensor/environmental
DATA=/var/data/sensors.dat
TMP=/tmp/sens.dat
PLOT=/usr/local/scripts/sens.gp
DEST=/var/www/www.herjulf.net/projects/sensor/environmental

function filter_old()
{
# Filter out sensor and remove tags so gnuplot can be used.
 tail -$2 $DATA | grep $1 | grep ^20 | sed 's/ID=//' | sed 's/UP=//' | sed 's/RH=//' |sed 's/T_MCU=//' | sed 's/V_MCU=//' | sed 's/T=//' | sed 's/RSSI=//'| sed 's/V_IN=//' > $TMP
}

function filter()
{
# Filter out sensor and remove tags so gnuplot can be used.
  tail -$2 $DATA | grep $1 | grep ^20 | /sbin/seltag 2 ID=%s T=%s RH=%s V_MCU=%s V_IN=%s RSSI=%s > $TMP
}

function filter_cap()
{
# Filter out sensor and remove tags so gnuplot can be used.
  tail -$2 $DATA | grep $1 | grep ^20 | /sbin/seltag 2 ID=%s V_IN=%s V_MCU=%s > $TMP
}

function plot()
{
 cd /tmp
#tail -$1 $DATA  >  $TMP
 /opt/gnuplot/bin/gnuplot < $PLOT > $DEST/$1
}

function remove_temp()
{
 rm -r $TMP
}

filter $1 $2
plot   $3

##  Do battery plot if needed
if [ 0004a == $1 ]; then
PLOT=/usr/local/scripts/sens-bat.gp
plot   UPS-battery-$3
#else
fi

##  Do cap plot if needed
if [ 00047 == $1 ]; then
PLOT=/usr/local/scripts/sens-cap.gp
filter_cap $1 $2 
plot   $3
#else
fi

function filter_AC_energy()
{
# Filter out sensor and remove tags so gnuplot can be used.
  tail -$2 $DATA | grep $1 | grep ^20 | /sbin/seltag 2 ID=%s T=%s RSSI=%s P0=%s P0_T=%s  > $TMP
}

##  Do energy plot if needed
if [ 005a == $1 ]; then
filter_AC_energy $1 $2
PLOT=/usr/local/scripts/sens-AC-energy.gp
plot   $3
#else
fi

remove_temp


