#include "UT61E.h"
#include "SerialPort.h"
#include <cstdlib>
#include <time.h>
#include <stdio.h>
#include <sys/time.h>
#include <iostream>

#define VERSION "Version 0.6 -- 1202147\n"

unsigned int lm = 0xFFFF;

#define P_DATE     (1<<0)
#define P_SAMPLE   (1<<1)
#define P_VALUE    (1<<2)
#define P_MAX      (1<<3)
#define P_MIN      (1<<4)
#define P_AVERAGE  (1<<5)
#define P_MODE     (1<<6)
#define P_POWER    (1<<7)
#define P_RANGE    (1<<8)

void usage(void) 
{
  printf("Usage: dmmut61e <serialport>\n");
  printf(VERSION);

  printf("logging mask fields:\n");
  printf(" DATE   %08x\n",   P_DATE);
  printf(" SAMPLE %08x\n",   P_SAMPLE);
  printf(" VALUE  %08x\n",   P_VALUE);
  printf(" MAX    %08x\n",   P_MAX);
  printf(" MIN    %08x\n",   P_MIN);
  printf(" AVERAGE  %08x\n",   P_AVERAGE);
  printf(" MODE   %08x\n",   P_MODE);
  printf(" POWER  %08x\n",   P_POWER);
  printf(" RANGE  %08x\n",   P_RANGE);
}

int main(int argc, char *argv[]) {
  if (argc == 1) {
    usage();
    exit(0);
  }	

  UT61E * dmm = new UT61E();
  SerialPort * port = new SerialPort(argv[1]);

  int res;
  char buf[14];

  while (true) {
    res = read(port->fd, buf, 14);

    if (dmm->check(buf) && res == 14) {
      dmm->parse(buf);

      time_t raw_time;
      struct tm *tp;

      time ( &raw_time );
      tp = gmtime ( &raw_time );

      if (!dmm->hold) {

	if(lm & P_DATE)
	  printf ("%04d-%02d-%02d %2d:%02d:%02d",
		  tp->tm_year+1900, tp->tm_mon+1, 
		  tp->tm_mday, tp->tm_hour, 
		  tp->tm_min, tp->tm_sec);

	if(lm & P_SAMPLE)
	  printf(" %ld", dmm->sample);
	if(lm & P_VALUE) 
	  printf(" %g", dmm->value);
	if(lm & P_MAX)
	  printf(" %g", dmm->max);
	if(lm & P_MIN)
	  printf(" %g", dmm->min);
	if(lm & P_AVERAGE)
	  printf(" %g", dmm->average);
	if(lm & P_MODE)
	  printf(" %s", dmm->getMode());
	if(lm & P_POWER)
	  printf(" %s", dmm->getPower());
	if(lm & P_RANGE)
	  printf(" %s", dmm->getRange());
	printf("\n");
      }
    } else 
      printf(" Invalid data\n");
  }
}
