#!/bin/bash
# Flash Upgrade of pwr-controller --r0

FPATH=/tmp
DEV=/dev/ttyUSB0
BAUD=38400
stty -F  $DEV sane

function upgrade
{
   avrdude -p m644p -c avr109 -P $DEV -b $BAUD -e -U flash:w:$FPATH/lead_led.hex -U eeprom:w:$FPATH/lead_led_eeprom.hex
}

function upgrade_init
{
    RES=$( { tty_talk -$BAUD $DEV upgr; } 2>&1 )
    OK=$(echo $RES | cut -d\  -f2)
}

for (( c=0; c<=10; c++ ))
 do
    if [ "$OK" != "OK" ]; then
	upgrade_init
    else
	upgrade
	break
    fi
 done



